DROP PROCEDURE [hips].[PcehrMessageQueueInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Simon Biber
-- Create date: 6 December 2012
-- Description:   Inserts a new record into the PcehrMessageQueue Table
-- Modified:
-- 15/09/2013 pstalley-gordon	added SourceSystemSetId & SourceSystemDocumentId
-- =============================================
CREATE PROCEDURE [hips].[PcehrMessageQueueInsert] 
(
	@QueueOperationId int,
	@QueueStatusId    int,
	@EpisodeId	int,
	@SourceSystemSetId varchar(128),
	@SourceSystemDocumentId varchar(128) = NULL,
	@SerialisedObject varbinary(max),
	@Request          xml = NULL,
	@Response         xml = NULL,
	@Details          varchar(max) = NULL,
	@UserModified     varchar(256)
) 
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode int
          , @PcehrMessageQueueId int

    SET @intErrorCode = 0


	INSERT INTO hips.PcehrMessageQueue
	(
		 [QueueOperationId]
		,[QueueStatusId]
		,[EpisodeId]
		,[SourceSystemSetId]
		,[SourceSystemDocumentId]
		,[SerialisedObject]
		,[Request]
		,[Response]
		,[Details]
		,[DateCreated]
        ,[UserCreated]
        ,[DateModified]
        ,[UserModified]
	)
VALUES
	(
		 @QueueOperationId
		,@QueueStatusId   
		,@EpisodeId
		,@SourceSystemSetId
		,@SourceSystemDocumentId
		,@SerialisedObject
		,@Request         
		,@Response        
		,@Details         
		,GETDATE()
		,@UserModified
		,GETDATE()
		,@UserModified
	)
	
SELECT @intErrorCode = @@ERROR , @PcehrMessageQueueId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT [PcehrMessageQueueId]
           ,pmq.[QueueOperationId]
		   ,qo.[Description] AS [QueueOperationName]
           ,pmq.[QueueStatusId]
		   ,qs.[Description] AS [QueueStatusDescription]
		   ,pmq.EpisodeId
		   ,pmq.SourceSystemSetId
		   ,pmq.SourceSystemDocumentId
           ,[SerialisedObject]
           ,[Request]
           ,[Response]
           ,[Details]
           ,pmq.[DateCreated]
           ,pmq.[UserCreated]
           ,pmq.[DateModified]
           ,pmq.[UserModified]
         FROM [hips].[PcehrMessageQueue] pmq
		 INNER JOIN [hips].[QueueOperation] qo ON pmq.[QueueOperationId] = qo.[QueueOperationId]
		 INNER JOIN [hips].[QueueStatus] qs ON pmq.[QueueStatusId] = qs.[QueueStatusId]
         WHERE [PcehrMessageQueueId] = @PcehrMessageQueueId
    END

    RETURN(@intErrorCode)

END
GO

